// --- START OF FILE background.js ---

chrome.commands.onCommand.addListener((command) => {
  if (command === "convert_text") {
    chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
      if (!tabs || !tabs[0]) return;

      // מנסים להזריק את הסקריפט
      // בגלל השינוי ב-content.js, אפשר להזריק אותו שוב ושוב בלי שגיאות
      chrome.scripting.executeScript({
        target: { tabId: tabs[0].id, allFrames: true },
        files: ["content.js"]
      }).catch(err => {
        // התעלמות משגיאות בדפים מוגנים (כמו chrome://settings)
        if (!err.message.includes("Cannot access contents")) {
          console.error("Script injection failed:", err);
        }
      });
    });
  }
});